<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../classi/CondivisioniFile.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $condivisioniFile = new CondivisioniFile($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $condivisioniFile = new CondivisioniFile($geecomDb, filter_input(INPUT_GET, "id"));
    }
    session_start();
    
    switch ($operazione) {
        case 'crea':
            $condivisioniFile->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $condivisioniFile->setContenutoDaCondividere(filter_input(INPUT_POST,"contenutoDaCondividere",FILTER_SANITIZE_STRING));
            $condivisioniFile->setCartellaDaCondividere(filter_input(INPUT_POST,"cartellaDaCondividere",FILTER_SANITIZE_STRING));
            $condivisioniFile->setFileDaCondividere(filter_input(INPUT_POST,"fileDaCondividere",FILTER_SANITIZE_STRING));
            $condivisioniFile->setDestinatari(filter_input(INPUT_POST,"destinatari",FILTER_SANITIZE_STRING));
            $condivisioniFile->setTesto(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_STRING));
            $condivisioniFile->setTermineCondivisione(filter_input(INPUT_POST,"termineCondivisione",FILTER_SANITIZE_STRING));
            $condivisioniFile->crea();
            header("Location: ../creaCondivisione.php?id={$condivisioniFile->getId()}&status=200");
            break;
        case 'modifica':
            $condivisioniFile->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $condivisioniFile->setContenutoDaCondividere(filter_input(INPUT_POST,"contenutoDaCondividere",FILTER_SANITIZE_STRING));
            $condivisioniFile->setCartellaDaCondividere(filter_input(INPUT_POST,"cartellaDaCondividere",FILTER_SANITIZE_STRING));
            $condivisioniFile->setFileDaCondividere(filter_input(INPUT_POST,"fileDaCondividere",FILTER_SANITIZE_STRING));
            $condivisioniFile->setDestinatari(filter_input(INPUT_POST,"destinatari",FILTER_SANITIZE_STRING));
            $condivisioniFile->setTesto(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_STRING));
            $condivisioniFile->setTermineCondivisione(filter_input(INPUT_POST,"termineCondivisione",FILTER_SANITIZE_STRING));
            $condivisioniFile->modifica();
            header("Location: ../creaCondivisione.php?id={$condivisioniFile->getId()}&status=250");
            break;
        case 'modificaFileCondivisioniFile':
            $tipiFileAmmessi = array("video/mp4","video/avi","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../file/video", 0, "");
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["percorso"]=="") {
                echo "Errore: formato immagine non ammesso";
                exit();
            }
            else {
                $percorsoCondivisioniFile = str_replace("../","",$esitoUpload["percorso"]);
            }
            $condivisioniFile->aggiornaPercorsoCondivisioniFile($percorsoCondivisioniFile);
            echo $percorsoCondivisioniFile;
            break;
        case 'duplica':
            $idCondivisioniFileDuplicato = $condivisioniFile->duplica();
            header("Location: ../creaCondivisioniFile.php?id={$idCondivisioniFileDuplicato}&status=210");
            break;
        case 'elimina':
            $condivisioniFile->elimina();
            echo "ok";
            break;
    }
